package com.patrick.app;

import java.time.LocalDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogParser {

    /**
     * Parses a string Minecraft connected/disconnected log and returns a ConnectionLog object.
     * @param log Connected/Disconnected log from Minecraft.
     * @return A ConnectionLog object.
     */
    public static ConnectionLog parseLog(String log) {
        // Using regex, we can quickly parse our String and take out what we need.
        // I highly recommend looking up regex and how to use it. Super powerful.
        Pattern pattern = Pattern.compile("\\[(.+) INFO\\] Player (.+)onnected: (.+), xuid: ([0-9]+)");
        Matcher matcher = pattern.matcher(log);

        // If it matches, we want to do stuff, else we don't want to give back anything.
        if(matcher.find()) {
            System.out.println("parsing log: " + log);

            // Regex-specific code. Basically based on the matches I have, I set them to different parts of the constructor.
            return new ConnectionLog(matcher.group(3), 
                matcher.group(4), 
                
                // I thought this was fun. Depending if I saw "disc" or "c" before "onnected", I'd know which status it was.
                matcher.group(2) == "disc" ? ConnectionLog.ConnectionStatus.DISCONNECTED : ConnectionLog.ConnectionStatus.CONNECTED,

                // Weird thing specifically for Minecraft logs. They come in the format:
                // YYYY-mm-dd HH:MM:SS:<milliseconds>
                // but the LocalDateTime parser expects
                // YYYY-mm-ddTHH:MM:SS.<milliseconds>
                // So here I just replace the space with a "T" and then cut off the milliseconds part because I don't really care about it.
                LocalDateTime.parse(matcher.group(1).replace(" ", "T").substring(0,19)));
        }
        else {
            return null;
        }
    }
}
