package com.patrick.app;

import java.time.LocalDateTime;

public class ConnectionLog {
    public enum ConnectionStatus {
        CONNECTED,
        DISCONNECTED
    }
    
    private String name;
    private String xuid;
    private ConnectionStatus status;
    private LocalDateTime time;

    public ConnectionLog(String name, String xuid, ConnectionStatus status, LocalDateTime time) {
        this.name = name;
        this.xuid = xuid;
        this.status = status;
        this.time = time;
    }
    
    public String getName() {
        return this.name;
    }

    public String getXuid() {
        return this.xuid;
    }

    public ConnectionStatus getConnectionStatus() {
        return this.status;
    }

    public LocalDateTime getTime() {
        return this.time;
    }
}